/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  timerA.c
//  Initialization and control of timerA
//	timerA is used to generate a PWM signal for setting the output voltage
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"



// initialization of Timer_A for PWM
void init_timerA(void)
{
	// reset timer
	set_bit(TACTL, TACLR);
	
	// SMCLK as source for Timer_A
	set_bit(TACTL, TASSEL1);
	clear_bit(TACTL, TASSEL0);
	
	// input divider 1 -> counter is running @ 16MHz
	clear_bit(TACTL, ID1);
	clear_bit(TACTL, ID0);
	
	// timer in Up-mode
	clear_bit(TACTL, MC1);
	set_bit(TACTL, MC0);
	
	// disable interrupt
  	clear_bit(TACTL, TAIE);
	
	// TACCR0 = 16000 ==> 16MHz / 16000 = 1000 Hz
	// TACCR1 sets PWM for the current
  	// TACCR2 sets PWM for the voltage
  	TACCR0 = 16000;
	TACCR1 = 0;
	TACCR2 = 0;


	// no capture
	clear_bit(TACCTL2, CM1);
	clear_bit(TACCTL2, CM0);
		
	// compare mode
	clear_bit(TACCTL2, CAP);
	
	// output mode: pins are controlled by timer_A, "Reset/Set mode"
//	set_bit(TACCTL2, OUTMOD2);
//	set_bit(TACCTL2, OUTMOD1);
//	set_bit(TACCTL2, OUTMOD0);
	TACCTL2 = OUTMOD_7;

	// disable compare interrupt
	clear_bit(TACCTL2, CCIE);

	
	// no capture
	clear_bit(TACCTL1, CM1);
	clear_bit(TACCTL1, CM0);

	// compare mode
	clear_bit(TACCTL1, CAP);

	// output mode: pins are controlled by timer_A, "Reset/Set mode"
//	set_bit(TACCTL1, OUTMOD2);
//	set_bit(TACCTL1, OUTMOD1);
//	set_bit(TACCTL1, OUTMOD0);
	TACCTL1 = OUTMOD_7;

	// disable compare interrupt
	clear_bit(TACCTL1, CCIE);



	// set timer output function
	set_bit(TA_PSEL, TA2_BIT_Vref);
	set_bit(TA_PSEL, TA1_BIT_iref);

	// set pin as output
	set_bit(TA_PDIR, TA2_BIT_Vref);
	set_bit(TA_PDIR, TA1_BIT_iref);

	// set output high
//	set_bit(TA_POUT, TA2_BIT_Vref);
//	set_bit(TA_POUT, TA1_BIT_iref);
//	set_bit(TA_POUT, TA0_BIT_fan);

}

